<?php
/**
 * DigiKash Blocks integration for WooCommerce Checkout Block
 */

if (!defined('ABSPATH')) {
    exit;
}

use Automattic\WooCommerce\Blocks\Payments\Integrations\AbstractPaymentMethodType;

final class WC_Gateway_DigiKash_Blocks extends AbstractPaymentMethodType {

    protected $name = 'digikash';

    public function initialize() {
        $this->settings = get_option('woocommerce_digikash_settings', []);
    }

    public function is_active() {
        return !empty($this->settings['enabled']) && 'yes' === $this->settings['enabled'];
    }

    public function get_payment_method_script_handles() {
        wp_register_script(
            'wc-digikash-blocks-integration',
            plugin_dir_url(__FILE__) . '../assets/js/checkout.js',
            [
                'wc-blocks-registry',
                'wc-settings',
                'wp-element',
                'wp-html-entities',
                'wp-i18n'
            ],
            '2.8.0', // Updated version for compact UI
            true
        );

        return ['wc-digikash-blocks-integration'];
    }

    public function get_payment_method_data() {
        // Get DigiKash gateway instance to access site info
        $gateway = new WC_Gateway_DigiKash();
        $site_info = $gateway->get_site_info();
        
        return [
            'title' => !empty($site_info['site_name']) ? $site_info['site_name'] : $this->get_setting('title', 'DigiKash'),
            'description' => !empty($site_info['gateway_description']) ? $site_info['gateway_description'] : $this->get_setting('description', 'Pay securely using DigiKash.'),
            'supports' => ['products'],
            'testmode' => 'yes' === $this->get_setting('testmode', 'yes'),
            'site_info' => $site_info // Pass all site info to frontend
        ];
    }

    protected function get_setting($key, $default = '') {
        return isset($this->settings[$key]) ? $this->settings[$key] : $default;
    }
}
